<?php
/*
Plugin Name: Seme4 Linked Data Platform
Description: Facilitates integration of the Seme4 Linked Data Platform within Wordpress
Version: 1.3
Author: Seme4 Ltd // Ian Millard
Author URI: http://www.seme4.com/
License: Copyright 2013 Seme4 Ltd. All rights reserved.
*/

//  are we viewing via wordpress admininstration/dashboard pages?
//  currently no admin options, but this is mostly what would be required
//  if ( is_admin() ) require_once 's4ldp-admin.php';

//  add hooks to instantiate normal viewing.
//  if appropriate, the request is handled by s4ldp-render.php 
//  template, which returns processing back to S4LDP now that
//  Wordpress templates etc have been initialised
add_filter('template_include', 's4ldp_template_include');
add_filter('redirect_canonical', 's4ldp_remove_trailing_slash');
add_filter('the_content',  's4ldp_get_content');
add_filter('wp_title', 's4ldp_set_html_title');
add_filter('widget_text', 'do_shortcode');
add_action('wp_enqueue_scripts', 's4ldp_stylesheet');
add_action('_core_updated_successfully', 's4ldp_after_core_upgrade');

//  add stylesheet
function s4ldp_stylesheet() {
	wp_register_style( 's4ldp', WP_PLUGIN_URL . '/' . basename( __DIR__ ) . '/s4ldp.css' );
	wp_enqueue_style ( 's4ldp' );
	wp_enqueue_script ( 'jquery' );
	wp_register_script( 'listnav', WP_PLUGIN_URL . '/' . basename( __DIR__ ) . '/jquery.listnav-2.1.js' );
	wp_enqueue_script ( 'listnav' );
}

//  return processing to S4LDP again, if appropriate
function s4ldp_template_include($template) {
	global $wp_query, $post, $ragld_page_data;

	//  come via S4LDP?
	if (defined('DEFER_TO_WORDPRESS') && DEFER_TO_WORDPRESS == true) {

		//  if S4LDP thinks it's a 404, then do whatever wordpress wants ;)
		if (defined('DEFER_TO_WORDPRESS_STATUS') && DEFER_TO_WORDPRESS_STATUS == '404') return $template;

		//  otherwise S4LDP wants to render something.
		//  fake some wordpress things to make it think there is a page ;)
		status_header('200');
		$wp_query->is_404 = false;  
		if ($wp_query->post_count == 0) {
			$wp_query->post_count = 1;
			$dummy = new stdClass();
			$dummy->ID = -1;
			$dummy->post_title = '';
			$dummy->post_type = 'page';
			$dummy->post_content = '';
			$wp_query->posts[] = new WP_Post($dummy);
			if(!wp_cache_get($dummy->ID, 'posts')) wp_cache_set($dummy->ID, $dummy, 'posts');
		}
		add_filter('the_title', 's4ldp_set_page_title');
		add_filter('body_class','s4ldp_add_body_class');

		//  if there are headers set by S4LDP, then ensure they are used
		if (isset($ragld_page_data['headers'])) {
			add_action('wp_head', function() { 
				global $ragld_page_data;
				print $ragld_page_data['headers'];
			});
		}

		//  use the "page" template if available, or else whatever
		//  wordpress was going to use in the first place (hope not 404)
		$new_template = TEMPLATEPATH . '/page.php';
		if (file_exists($new_template)) return $new_template;

	}

	//  default is to return whatever wordpress was going to use anyway :)
	return $template;
}

//  set the page title in template from S4LDP, if required
function s4ldp_set_page_title($title) {
	global $ragld_page_data;
	if (defined('DEFER_TO_WORDPRESS')
        && (!defined('DEFER_TO_WORDPRESS_STATUS') || DEFER_TO_WORDPRESS_STATUS != '404')
	&& ($title == '')
	&& isset($ragld_page_data['title'])) 
		return strip_tags($ragld_page_data['title']);

	//  default - return original title
	return $title;
}

//  set the  HTML page title from S4LDP, if required (uses pipe symbol to join title with site title)
function s4ldp_set_html_title($title) {
	global $ragld_page_data;
	if (defined('DEFER_TO_WORDPRESS')
        && (!defined('DEFER_TO_WORDPRESS_STATUS') || DEFER_TO_WORDPRESS_STATUS != '404')
	&& ($title == '')) {
		if (isset($ragld_page_data['html_title'])) return strip_tags($ragld_page_data['html_title']) . ' | ';
		if (isset($ragld_page_data['title']))      return strip_tags($ragld_page_data['title']) . ' | ';
	}

	//  defautlt - return original title
	return $title;
}

//  get content by returning processing to S4LDP
function s4ldp_get_content($content) {
	global $ragld_content;

	//  if there is existing content from wordpress for this page
	//  then render that, injecting S4LDP data if required by
	//  replacing shortcode [s4ldp] with the S4LDP content
	if (strlen(trim($content)) > 0) {

		//  little hack to alter some of the ragld content slightly
		$ragld_content = preg_replace('@<p>([0-9]+) results found</p>@', '<p>Or browse all \1 available entries...</p>', $ragld_content);

		return str_replace('[s4ldp]', $ragld_content, $content);
	}

	//  if there is content from S4LDP, then use that
	if (strlen(trim($ragld_content)) > 0) return $ragld_content;

	//  shouldn't get here, but if all else fails return any existing WP content
	return $content;	
}

//  inject search results from S4LDP. call this function from within your search.php
//  TODO - location of search service and stylesheet are currently hard coded
function s4ldp_do_search() {
	$query = get_search_query(false);
	$error = false;
	$results = null;
	try {
		$results = @file_get_contents('http://' . $_SERVER['HTTP_HOST'] . '/search/query/' . urlencode($query) . '/partial');
	} catch (Exception $e) {
		$error = true;
	}

	if ($results == null || $error || trim($results) == '') return '<p class="s4ldp-search-error">Error: failed to connect to search service</p>';

	if (trim($results) == 'No results found') {
		$results = '<h1 class="entry-title">No resources found</h1><p>Sorry, but no resources matched your search terms.</p>';
	} else {

		$results .= '<p class="altSearch">Too broad? Try searching just ' .
				"<a href=\"/resources/capabilities/?search="  . urlencode($query) . "\">capabilities/techniques</a>, " .
				"<a href=\"/resources/researchers/?search="   . urlencode($query) . "\">people</a>, " .
				"<a href=\"/resources/organisations/?search=" . urlencode($query) . "\">organisations</a> or " .
				"<a href=\"/resources/equipment/?search="     . urlencode($query) . "\">equipment</a>.</p>";
		
	}
	

	return '<h1 class="entry-title">Photonics resources</h1>' . $results . '<hr class="searchSeparator">';

}

//  remove with trailing slashes in incoming requests for .html URIs
function s4ldp_remove_trailing_slash($redirect_url) {
	if (substr($redirect_url, -6) == '.html/') return substr($redirect_url, 0, -1);
	else return $redirect_url;
}

//  this function adds the class 's4ldp' to the body element
//  called by add_filter('body_class', 's4ldp_add_body_class');
function s4ldp_add_body_class($classes) {
	$classes[] = 's4ldp';
	return $classes;
}

//  add a shortcode/tag for list index search box 
//  [searchbox type="foaf:Person"]
function s4ldp_searchbox( $atts ) {
	extract( shortcode_atts( array(
		'type' => null,
		'label' => null,
	), $atts ) );

	if ($type != null) $type = '&type=' . urlencode($type);
	if ($label == null) $label = 'Search all photonics resources...';

        if (isset($_REQUEST['search']) && strlen(trim($_REQUEST['search'])) > 0) {
		$searchTerm = trim($_REQUEST['search']);
		$doSearch = "\n  jQuery(\"#searchbox\").submit();";
	} else {
		$searchTerm = '';
		$doSearch = '';
	}

	$form  = '<form id="searchbox"><input type="text" id="q" placeholder="'.$label.'" value="' . $searchTerm . '"></form>';
        $form .= '<div id="searchbox-results" class="hidden"></div>';
	$form .= '<script type="text/javascript"> 
  jQuery(document).ready(function() {
    jQuery("#searchbox").submit(function(e) {
      if (jQuery("#q").val().length == 0) return false;
      jQuery("#searchbox-results").load("/search/query/?match=partial&field=triples.rdfs:label'.$type.'&search=" + encodeURIComponent(jQuery("#q").val()), function() {
        jQuery("#indexList").slideDown();
      });
      return false;
    });'.$doSearch.'
  });
</script>';

	return $form; 
}
add_shortcode( 'searchbox', 's4ldp_searchbox' );


//  shortcode for widgets, embed search box which jumps to
//  relevant page (people, orgs, etc)
function s4ldp_widget_searchbox( $atts ) {
	extract( shortcode_atts( array(
		'page' => null,
		'label' => null,
	), $atts ) );

	if ($page == null) return "[Error - missing \$page]";
	if ($label == null) $label = 'Search...';

	return '<form class="widget_search" action="/resources/' . $page . '/"><input type="text" name="search" placeholder="'.$label.'""></form>';

}
add_shortcode( 'widget_search', 's4ldp_widget_searchbox' );

//  standard search box
add_shortcode('search_everything', 'get_search_form');


//  after a core upgrade, ensure the correct (modified) index.php.s4ldp
//  is moved back to replace standard index.php
function s4ldp_after_core_upgrade($wp_version) {

	$origin = ABSPATH . '/index.php';
	$custom = ABSPATH . '/index.php.s4ldp';

	if (file_exists($custom) && is_readable($custom) && is_writable($origin) && (md5_file($origin) != md5_file($custom))) 
		copy($custom, $origin);
}
