<?php 

//
//  Settings (options) page for S4LDP plugin
//
//  We just use the in-built Wordpress settings, see
//  http://codex.wordpress.org/Settings_API
//

//  define the settings we wish to make available
add_action('admin_init', 's4ldp_register_settings');
function s4ldp_register_settings() {
  register_setting( 's4ldp_pub', 'new_option_name' );
  register_setting( 's4ldp_pub', 'some_other_option' );
  register_setting( 's4ldp_pub', 'option_etc' );
}

//  register the settings page in admin menu
add_action('admin_menu', 's4ldp_admin_add_page');
function s4ldp_admin_add_page() {
    add_options_page('Seme4 Linked Data Platform Options', 'Seme4 LDP', 'manage_options', 's4ldp', 's4ldp_settings_page');
}

//  register settings link on plugin listing/activation page
add_filter('plugin_action_links', 's4ldp_settings_link', 2, 2);
function s4ldp_settings_link($actions, $file) {
	if ( false !== strpos( $file, 's4ldp' ) )
		$actions['settings'] = '<a href="options-general.php?page=s4ldp">Settings</a>';
	return $actions; 
}

//  produce settings page
function s4ldp_settings_page() {
?>
<div class="wrap">
  <?php screen_icon(); ?>
  <h2>Seme4 Linked Data Platform</h2>
  <p>Options relating to the integration of S4LDP into Wordpress</p>
  <form action="options.php" method="post">
    <?php settings_fields('s4ldp_pub'); ?>
    <?php do_settings_sections('s4ldp'); ?>
    <input name="Submit" type="submit" value="<?php esc_attr_e('Save Changes'); ?>" />
  </form>
</div>
<?php
}

//  add rewrite rules for URL handling
add_action('generate_rewrite_rules', 's4ldp_rewrite_rules');
function s4ldp_rewrite_rules($wp_rewrite) {
        $rewrite_rules["id/(.+)/?$"] = 'index.php?s4ldp_publish_uri=$matches[1]';
        $wp_rewrite->rules = $rewrite_rules + $wp_rewrite->rules;
print "<pre>" . print_r($wp_rewrite->rules, true) . "</pre>\n";
}


?>
